/*
	Stempora Web Framework
	Copyright (c) 2002-2018 Stempora. 
	All rights reserved.
		web:  www.stempora.com
		mail: support@stempora.com				
*/

var STBGalleryEffectsG1 = Object.create(STBModule.prototype);

STBGalleryEffectsG1.name = "GalleryEffectsG1";
STBGalleryEffectsG1.initEffect = function() {
        var dir = jQuery('.dir:not(.__done)');

        if (dir.length > 0) {
            var hoverD = function () {
                jQuery(this).hoverdir({
                    hoverDelay: 75
                });
            };

            dir.each(hoverD);

			dir.imagesLoaded(function() {

				dir.each(function() {

					var 
						title = jQuery(this).find(".title"),
						body = jQuery(this).find(".description"),
						dates = jQuery(this).find(".dates"),
						btn = jQuery(this).find(".btn"),
						max = jQuery(this).height();

	
					body.css("max-height" , "auto");

					if (title.length) {
						max -= title.height() + 10;
					}

					if (btn.length) {
						max -= btn.height() + 20;
					}

					if (dates.length) {

						if (dates.prop('noteName') == "ul")	{
							if (!dates.find("li").length) {
								dates.remove();
							} else {
								max -= dates.height() + 20;
							}
						} else {
							max -= dates.height() + 20;
						}
						
					}

					//top, bottom margins
					max -= 50;

					var lines = Math.floor(max/24);

					body.css("max-height" , lines * 24);

					var iso = jQuery(this).closest(".isotope-container");
					if (iso.length > 0)	{
						if (iso.data("isotope")) {
							iso.isotope('layout');
						}	
					}

					jQuery(this).addClass("__done");
				});
			});


        }
}


STBGalleryEffectsG1.resetDone = function() {
	jQuery('.dir.__done').removeClass("__done");
}

STBGalleryEffectsG1.runOnLoad = function() {
	STBGalleryEffectsG1.initEffect();
}

STBGalleryEffectsG1.runOnContentUpdate = function() {
	STBGalleryEffectsG1.initEffect();
}

STBGalleryEffectsG1.runOnResize = function() {
	STBGalleryEffectsG1.resetDone();
	STBGalleryEffectsG1.initEffect();
}

site.registerModule(STBGalleryEffectsG1);